;-------------------------------------------------
;	VX-3 128KB RAM check program
;-------------------------------------------------

RWERR:	EQU	&H3274		;RW Error
LEDTP:	EQU	&H6343		;LCD buffer


	ORG	LEDTP
	START	START
;
;	10000-15FFFh (bank1)
;
START:	LDW	$0,&H6000	;end address + 1 = &H6000
	XRW	$2,$2		;start address   = &H0000
	CAL	VERIFY
;
;	24000-2FFFFh (bank2)
;
	PST	UA,&H65		;ix = bank 2
	XRW	$0,$0		;end address + 1 = &H0000
	LDW	$2,&H4000	;start address   = &H4000
	CAL	VERIFY

	PST	UA,&H54		;reset bank
	RTN
;
;	verify routine
;
VERIFY:	LD	$4,$31		;initialize test data
	PRE	IX,$2		;set start address
WRITE:	STI	$4,(IX+$31)	;write test data
	AD	$4,$30		;increment test data
	GRE	IX,$5		;
	SBCW	$5,$0		;end check
	JR	NZ,WRITE	;

	LD	$4,$31		;initialize test data
	PRE	IX,$2		;set start address
READ:	SBC	(IX+$31),$4	;compare data
	JR	NZ,ERROR	;
	STI	$31,(IX+$31)	;write 00h
	AD	$4,$30		;increment test data
	GRE	IX,$5		;
	SBCW	$5,$0		;end check
	JR	NZ,READ		;

	RTN
;
;	RW error
;
ERROR:	PST	UA,&H54		;reset bank
	JP	RWERR
